*Produces Table 2: The Housing Equity Withdrawal and Refinancing Channel

"<place directory here>" 

use "`location'\UnbalancedHH.dta" , clear 
merge m:1 year using "`location'\cashrate.dta" , nogen keep(match master)
replace cashrate = cashrate/100 

gen str7 z = string(xwaveid,"%07.0f")
rename xwaveid waveid 
rename z xwaveid 

*Weights
g hwt_noadj =  hhwth
g hwt_adj = hhwthm 

g hwt_new = hwt_noadj
replace hwt_new = hwt_adj if hwt_noadj == 0

*******************************
*TIME SINCE PURCHASE AND REFINANCE
*******************************

g yearsataddress = hsyrcad
replace yearsataddress = . if yearsataddress<0
replace yearsataddress = round(yearsataddress,1)

g yearmoved = mhyr

*Purchase
g purchyear = hsyr 
g purchprice = hsprice
g purchdebt = hsloana

replace purchyear = . if purchyear < 0
replace purchprice = . if purchprice < 0
replace purchdebt = 0 if purchdebt < 0

foreach i in purchyear purchprice purchdebt {
foreach j in 2002 2006 2010 2014 2018 {
g `i'`j' = `i' if year == `j'
bysort xwaveid: egen `i'`j'max = max(`i'`j') 
}
}


*There are some inconsistencies here but seems ok:
g purchyear_report = .
g purchprice_report = .
g purchdebt_report = .

foreach i in purchyear purchprice purchdebt {
foreach j in 2002 2006 2010 2014 2018 {
replace `i'_report = `i'`j'max if year >= purchyear`j'max
}
}

foreach i in purchyear purchprice purchdebt {
foreach j in 2002 2006 2010 2014 2018 {
drop `i'`j'max `i'`j'
}
}

g purchduration =year-purchyear_report

*Refinancings

*R17 Have the original home loans on this property ever been refinanced
*Only asked of owner-occupiers 
g refinance = (hsevref==1)
replace refinance = . if hsevref < 0 

*Total value AFTER refinancing
g refdebt = hsrefvl
replace refdebt = . if refdebt < 0

g refyear = hsrefy
replace refyear = . if refyear < 0


foreach i in refyear refdebt {
foreach j in 2006 2010 2014 2018 {
g `i'`j' = `i' if year == `j'
bysort xwaveid: egen `i'`j'max = max(`i'`j') 
}
}

g refyear_report = .
g refdebt_report = .
foreach i in refyear refdebt {
foreach j in 2006 2010 2014 2018 {
replace `i'_report = `i'`j'max if year >= refyear`j'max
}
}

foreach i in refyear refdebt {
foreach j in 2006 2010 2014 2018 {
drop `i'`j'max `i'`j'
}
}

g refduration = year-refyear_report

*MORTGAGE DURATION
*This updates for time of refinance
g pduration = purchduration
replace pduration = yearsataddress if yearsataddress < pduration 
replace pduration = refduration if refduration < pduration 
replace pduration = 0 if pduration == -1


*This is the purchase year based on either reported year or years at address
*It is adjusted for refinancing
g origyear = year-pduration

***************************
*STOCK OF DEBT AT ORIGINATION
***************************

*Updates the stock if there has been a refinance
*Important to base it in reported estimates 
g origdebt = purchdebt_report
replace origdebt = refdebt_report if refdebt_report ~=.


egen id = group(xwaveid)
tsset id year 

*************
*Demographics
*************

g dinc = hifditp -hifditn
g ldinc = log(dinc)

g age = hgage
g agesq= age*age

g  emp = (esbrd==1)
g unemp = (esbrd==2)
replace unemp = . if esbrd < 0

g selfemp =  (esempst>1)
replace selfemp = . if esempst==.
g employee = (esempst==1)

g casual = (jbcasab==1)

g underemp = (jbhrcpr==3)
replace underemp = 0 if emp == 0

g owner = (hstenr==1)
replace owner = 1 if hstenur==1 & year == 2001

*Moved since previous wave 
g moved = (hhmove==1)
replace moved = . if hhmove < 0

tsset id year 
g smoved = moved +l1.moved +l2.moved +l3.moved
*Estimated over 4-year window 
g moved4 = (smoved > 0)



*DV: Household Debt [imputed] ($) [weighted topcode]
g hhdebt = hwdebti  
g lhhdebt = log(hhdebt)


merge 1:1 xwaveid year using "`location'\required_new.dta" ,nogen keep(match master)

*Only in wealth modules 
*Household wealth: Home: Apportioned debt [imputed] ($) [weighted topcode] 
g hdebt1 = hwhmdti 
*Household wealth: Other property: Apportioned debt [imputed] ($) [weighted topcode]
g hdebt2 = hwopdti
*Includes debt on second home 
g hdebt = hdebt1+hdebt2 

*Prepayment buffer (only estimated on owner occuper debt???)
g buffer = schedule-hdebt1 
replace buffer = 0 if buffer < 0 
 
*Liquidity 
g cash = hwcaini
g deposits = hwtbani
g equities = hweqini 
g trusts= hwtrusi
g super_retiree = hwsupri 

g buffer1 = schedule-hdebt1  
replace buffer1 = 0 if buffer1< 0 

*INCLUDES RETIREE SUPER AND REDRAW BUFFER 
g liqasset = cash + deposits + equities + trusts 
replace liqasset = liqasset + super_retiree 
replace liqasset = liqasset + buffer if buffer ~=.

g liqratio = liqasset/dinc
replace liqratio = liqratio*12 
su liqratio, det 


g module = 0
replace module = 1 if year == 2002 | year == 2006 | year == 2010 | year == 2014 | year == 2018

g renter = (hstenur == 2)
replace renter = 1 if hstenr == 2

g mortgagor = (hsmguse== 1)


g hvalue = hsvalui
replace hvalue = . if hvalue < 0 

g mort1 = hsmgi 
g mort2 = hssli
replace mort1 = 0 if mort1<0
replace mort2 = 0 if mort2<0
replace mort1 = mort1*12
replace mort2 = mort2*12 
g mort = mort1+mort2 
su mort*

*Rolling 4-year sum
tsset id year 
g mort1sum = mort1+l1.mort1 +l2.mort1 +l3.mort1
g mortsum = mort+l1.mort +l2.mort +l3.mort

*Only get this measure every 4 years 
*Need to check definitions are aligned with repayments data 
g hdebtch = hdebt-l4.hdebt
g hdebt1ch = hdebt1-l4.hdebt1

*************
*IMPORTANT
*************
drop if age < 18
drop if age > 80 

keep if module == 1 
g period = 0
replace period = 1 if year == 2002
replace period = 2 if year == 2006
replace period = 3 if year == 2010
replace period = 4 if year == 2014
replace period = 5 if year == 2018
tsset id period


*First difference based on wealth modules 
g dliqasset = liqasset-l1.liqasset 


g lhdebt = log(hdebt)
g lhdebt1 = log(hdebt1)
g lliqasset = log(liqasset)
g lhvalue = log(hvalue)

g ihdebt = log(hdebt+sqrt(hdebt^2+1))
g iliqasset = log(liqasset+sqrt(liqasset^2+1))

g dhdebt= hdebt-l1.hdebt
g dhdebt1 =hdebt1-l1.hdebt1
g ddinc = dinc-l1.dinc 

g dlhdebt = d.lhdebt 
g dlhdebt1 = d.lhdebt1
g dlliqasset = d.lliqasset 
g dhvalue = hvalue-l1.hvalue 
g dlhvalue = d.lhvalue 

g dihdebt = d.ihdebt 
g diliqasset = d.iliqasset 

g notmoved = (yearsataddress< 5)
replace notmoved = . if yearsataddress==.


g reftime = year-refyear 
replace reftime = . if refyear == . 

*Refinanced in past 4 years 
g refinance4 = (reftime < 5)
replace refinance4 = 0 if reftime == .

*Refinanced in past year 
g refinance1 = (reftime < 2)
replace refinance1 = 0 if reftime == .


*Household wealth: Home: Apportioned equity loan ($) [weighted topcode]
g hew = hwhmeql
replace hew = . if hew < 0

g hewloan = (hew>0)
replace hewloan = . if hew == . 


*Only got these data since 2014 
g ioloan = (hsmgtl2==2)
replace ioloan = . if hsmgtl2 < 0 

g pdurationsq = pduration*pduration

su dliqasset dhdebt, det 

xtile dliqasset_nq = dliqasset, nq(100)
xtile dhdebt_nq = dhdebt, nq(100)

g outlier = 0
replace outlier = 1 if dliqasset_nq == 1 | dliqasset_nq == 100
replace outlier = 1 if dhdebt_nq == 1 | dhdebt_nq == 100
*replace outlier = 1 if dliqasset > 1000000
*replace outlier = 1 if dliqasset < -1000000
*replace outlier = 1 if dhdebt> 1000000
*replace outlier = 1 if dhdebt < -1000000

******************
*DEBT AMORTISATION
******************

g refinance4_dhdebt = dhdebt*refinance4 
g hew_dhdebt = hewloan*dhdebt 

g refinance1_dhdebt = dhdebt*refinance1

g refinance_or_hew = refinance4 
replace refinance_or_hew = 1 if hewloan == 1 

g refinance4_hew_dhdebt = refinance_or_hew*dhdebt 


************
*FOR RDP
************

*OLS with no controls 
reg dliqasset dhdebt if mortgagor == 1 & outlier == 0 , cl(xwaveid) 
*OLS with controls 
reg dliqasset  dhdebt  dhvalue  ddinc age agesq i.pduration  i.year if mortgagor == 1 & outlier == 0 , cl(xwaveid) 
*With interaction for HEW/refinance 
reg dliqasset  dhdebt refinance_or_hew refinance4_hew_dhdebt  dhvalue  ddinc age agesq i.pduration i.year if mortgagor == 1 & outlier == 0 , cl(xwaveid) 


